package editor;

import game.CustomImageDataII;
import game.IntRect;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;

public class ForwardBackwardPaletteObject extends PaletteObject {
	
	private IntRect forwardRect;
	private IntRect backwardRect;
	
	public ForwardBackwardPaletteObject(RoomEditorPanel theParent, IntRect theClickRect, int theDistanceToBorder, int theBorderWidth) {
		
		this.isSelected = false;
		
		this.image = new CustomImageDataII("/images/selection forward or backward.GIF", Color.white, theParent);
		this.clickRect = theClickRect;
		this.editorPanel = theParent;
		
		this.distanceToBorder = theDistanceToBorder;
		this.borderWidth = theBorderWidth;
		
		this.forwardRect = new IntRect(theClickRect.getMinX(), theClickRect.getMinY(), theClickRect.width(), 32);
		this.backwardRect = new IntRect(theClickRect.getMinX(), theClickRect.getMinY() + 52, theClickRect.width(), 32);
		
	}
	
	public void setSelected(boolean b) {
		this.isSelected = false;
	}
	
	
	
	
	@Override
	public void draw(Graphics g) {
		
		
		if(clickRect == null)
			return;
		
		Point p = clickRect.getCenter();
		
		image.drawObjectFromUpperLeftCorner(g, clickRect.getMinX(), clickRect.getMinY());
		
		Color origCol = g.getColor();
		
		
		g.setColor(new Color(200, 100, 100));
		
		
		for(int i = 0; i < borderWidth; i++) {
			g.drawRect(clickRect.getMinX() - (distanceToBorder + i), clickRect.getMinY() - (distanceToBorder + i), clickRect.width() + (distanceToBorder + i) * 2, clickRect.height() + (distanceToBorder + i) * 2);
		}
		
		
		g.fillRect(clickRect.getMinX() - distanceToBorder - 1, clickRect.getMinY() + 37, clickRect.width() + 2 * (distanceToBorder + 1), 10);
		
		
		
		g.setColor(origCol);
		
		
		
	}
	
	
	public void onClick(MouseEvent e, Point p, ArrayList<ScreenObject> list) {
		
		if(forwardRect.contains(p)) {
//			System.out.println("<><>DELME moving forward...");
			ArrayMoveOver.moveItemsForward(list);
		} else if(backwardRect.contains(p)) {
//			System.out.println("<><>DELME moving backward...");
			ArrayMoveOver.moveItemsBack(list);
		}
		
	}
	
}
	